/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.ForgottenRenderer;
import vazkii.quark.content.mobs.entity.ForgottenEntity;
import vazkii.quark.content.mobs.item.ForgottenHatItem;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class ForgottenModule
extends QuarkModule {
    public static EntityType<ForgottenEntity> forgottenType;
    public static Item forgotten_hat;
    @Config(description="1 in this many Skeletons that spawn under the threshold are replaced with Forgotten.")
    public double forgottenSpawnRate = 0.05;
    @Config
    public int maxHeightForSpawn = 20;

    @Override
    public void construct() {
        forgotten_hat = new ForgottenHatItem(this);
        forgottenType = EntityType.Builder.func_220322_a(ForgottenEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 2.4f).func_233606_a_(8).setCustomClientFactory((spawnEntity, world) -> new ForgottenEntity((EntityType<? extends ForgottenEntity>)forgottenType, (World)world)).func_206830_a("forgotten");
        RegistryHelper.register(forgottenType, (String)"forgotten");
        EntitySpawnHandler.addEgg(forgottenType, 9868423, 0x3A3330, this, () -> true);
    }

    @Override
    public void setup() {
        super.setup();
        GlobalEntityTypeAttributes.put(forgottenType, (AttributeModifierMap)ForgottenEntity.registerAttributes().func_233813_a_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(forgottenType, ForgottenRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSkeletonSpawn(LivingSpawnEvent.CheckSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        Event.Result result = event.getResult();
        if (entity.func_200600_R() == EntityType.field_200741_ag && entity instanceof MobEntity && result != Event.Result.DENY && entity.func_226278_cu_() < (double)this.maxHeightForSpawn && entity.field_70170_p.field_73012_v.nextDouble() < this.forgottenSpawnRate) {
            MobEntity mob = (MobEntity)entity;
            if (result == Event.Result.ALLOW || mob.func_213380_a((IWorld)entity.field_70170_p, event.getSpawnReason()) && mob.func_205019_a((IWorldReader)entity.field_70170_p)) {
                ForgottenEntity forgotten = new ForgottenEntity(forgottenType, entity.field_70170_p);
                Vector3d epos = entity.func_213303_ch();
                forgotten.func_70080_a(epos.field_72450_a, epos.field_72448_b, epos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
                forgotten.prepareEquipment();
                entity.field_70170_p.func_217376_c((Entity)forgotten);
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

