/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientManager;

public class BookmarkList
implements IIngredientGridSource {
    private final List<Object> list = new LinkedList<Object>();
    private final List<IIngredientListElement<?>> ingredientListElements = new LinkedList();
    private final IngredientManager ingredientManager;
    private final BookmarkConfig bookmarkConfig;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public BookmarkList(IngredientManager ingredientManager, BookmarkConfig bookmarkConfig) {
        this.ingredientManager = ingredientManager;
        this.bookmarkConfig = bookmarkConfig;
    }

    public <T> boolean add(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        T normalized = ingredientHelper.normalizeIngredient(ingredient);
        if (!this.contains(normalized) && this.addToLists(normalized, true)) {
            this.notifyListenersOfChange();
            this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.ingredientListElements);
            return true;
        }
        return false;
    }

    private boolean contains(Object ingredient) {
        IIngredientHelper<Object> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        for (Object existing : this.list) {
            if (ingredient == existing) {
                return true;
            }
            if (existing == null || existing.getClass() != ingredient.getClass() || !BookmarkList.equalUids(ingredientHelper, existing, ingredient)) continue;
            return true;
        }
        return false;
    }

    private static boolean equalUids(IIngredientHelper<Object> ingredientHelper, Object a, Object b) {
        String uidA = ingredientHelper.getUniqueId(a, UidContext.Ingredient);
        String uidB = ingredientHelper.getUniqueId(b, UidContext.Ingredient);
        return uidA.equals(uidB);
    }

    public boolean remove(Object ingredient) {
        int index = 0;
        for (Object existing : this.list) {
            if (ingredient == existing) {
                this.list.remove(index);
                this.ingredientListElements.remove(index);
                this.notifyListenersOfChange();
                this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.ingredientListElements);
                return true;
            }
            ++index;
        }
        return false;
    }

    public <T> boolean addToLists(T ingredient, boolean addToFront) {
        IIngredientListElement<T> element = IngredientListElementFactory.createUnorderedElement(ingredient);
        if (addToFront) {
            this.list.add(0, ingredient);
            this.ingredientListElements.add(0, element);
        } else {
            this.list.add(ingredient);
            this.ingredientListElements.add(element);
        }
        return true;
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientList(String filterText) {
        return this.ingredientListElements;
    }

    public boolean isEmpty() {
        return this.ingredientListElements.isEmpty();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

