/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.OptifineHandler;
import com.simibubi.create.foundation.render.backend.gl.GlFogMode;
import com.simibubi.create.foundation.render.backend.gl.GlObject;
import com.simibubi.create.foundation.render.backend.gl.shader.FogSensitiveProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.GlProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.GlShader;
import com.simibubi.create.foundation.render.backend.gl.shader.IMultiProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramSpec;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderConstants;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderType;
import com.simibubi.create.foundation.render.backend.gl.shader.SingleProgram;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.lwjgl.system.MemoryUtil;

public class ShaderLoader {
    public static final String SHADER_DIR = "flywheel/shaders/";
    public static final ArrayList<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".vert", ".vsh", ".frag", ".fsh", ".glsl"});
    private static final Pattern includePattern = Pattern.compile("#flwinclude <\"([\\w\\d_]+:[\\w\\d_./]+)\">");
    final Map<ResourceLocation, String> shaderSource = new HashMap<ResourceLocation, String>();

    void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.SHADERS)) {
            OptifineHandler.refresh();
            Backend.refresh();
            if (Backend.gl20()) {
                this.shaderSource.clear();
                this.loadShaderSources(manager);
                Backend.programs.values().forEach(IMultiProgram::delete);
                Backend.programs.clear();
                Backend.registry.values().forEach(this::loadProgramFromSpec);
                Backend.log.info("Loaded all shader programs.");
            }
        }
    }

    private void loadShaderSources(IResourceManager manager) {
        Collection allShaders = manager.func_199003_a(SHADER_DIR, s -> {
            for (String ext : EXTENSIONS) {
                if (!s.endsWith(ext)) continue;
                return true;
            }
            return false;
        });
        for (ResourceLocation location : allShaders) {
            try {
                IResource resource = manager.func_199002_a(location);
                String file = this.readToString(resource.func_199027_b());
                ResourceLocation name = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring(SHADER_DIR.length()));
                this.shaderSource.put(name, file);
            }
            catch (IOException iOException) {}
        }
    }

    private <P extends GlProgram, S extends ProgramSpec<P>> void loadProgramFromSpec(S programSpec) {
        if (programSpec.fogSensitive) {
            EnumMap<GlFogMode, P> programGroup = new EnumMap<GlFogMode, P>(GlFogMode.class);
            for (GlFogMode fogMode : GlFogMode.values()) {
                programGroup.put(fogMode, this.loadProgram(programSpec, fogMode));
            }
            Backend.programs.put(programSpec, new FogSensitiveProgram(programGroup));
        } else {
            P program = this.loadProgram(programSpec, GlFogMode.NONE);
            Backend.programs.put(programSpec, new SingleProgram<P>(program));
        }
        Backend.log.debug("Loaded program {}", (Object)programSpec.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P extends GlProgram, S extends ProgramSpec<P>> P loadProgram(S programSpec, GlFogMode fogMode) {
        GlObject vert = null;
        GlObject frag = null;
        try {
            ShaderConstants defines = new ShaderConstants(programSpec.defines);
            defines.defineAll(fogMode.getDefines());
            vert = this.loadShader(programSpec.getVert(), ShaderType.VERTEX, defines);
            frag = this.loadShader(programSpec.getFrag(), ShaderType.FRAGMENT, defines);
            GlProgram.Builder builder = GlProgram.builder(programSpec.name, fogMode).attachShader((GlShader)vert).attachShader((GlShader)frag);
            programSpec.attributes.forEach(builder::addAttribute);
            Object p = builder.build(programSpec.factory);
            return p;
        }
        finally {
            if (vert != null) {
                vert.delete();
            }
            if (frag != null) {
                frag.delete();
            }
        }
    }

    private String processIncludes(ResourceLocation baseName, String source) {
        HashSet<ResourceLocation> seen = new HashSet<ResourceLocation>();
        seen.add(baseName);
        return this.includeRecursive(source, seen).collect(Collectors.joining("\n"));
    }

    private Stream<String> includeRecursive(String source, Set<ResourceLocation> seen) {
        return new BufferedReader(new StringReader(source)).lines().flatMap(line -> {
            String includeSource;
            String includeName;
            ResourceLocation include;
            Matcher matcher = includePattern.matcher((CharSequence)line);
            if (matcher.find() && seen.add(include = new ResourceLocation(includeName = matcher.group(1))) && (includeSource = this.shaderSource.get(include)) != null) {
                return this.includeRecursive(includeSource, seen);
            }
            return Stream.of(line);
        });
    }

    private GlShader loadShader(ResourceLocation name, ShaderType type, ShaderConstants defines) {
        String source = this.shaderSource.get(name);
        source = this.processIncludes(name, source);
        if (defines != null) {
            source = defines.process(source);
        }
        return new GlShader(type, name, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readToString(InputStream is) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = this.readToBuffer(is);
            int i = bytebuffer.position();
            ((Buffer)bytebuffer).rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return null;
    }

    public ByteBuffer readToBuffer(InputStream is) throws IOException {
        ByteBuffer bytebuffer;
        if (is instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)is;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(is);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }
}

