/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.render.backend.light.GridAlignedBB;
import com.simibubi.create.foundation.render.backend.light.LightUpdateListener;
import com.simibubi.create.foundation.render.backend.light.LightUpdater;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeltTileEntity
extends KineticTileEntity
implements LightUpdateListener {
    public Map<Entity, BeltMovementHandler.TransportedEntityInfo> passengers;
    public Optional<DyeColor> color;
    public int beltLength;
    public int index;
    public Direction lastInsert;
    public CasingType casing;
    protected BlockPos controller = BlockPos.field_177992_a;
    protected BeltInventory inventory;
    protected LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    public CompoundNBT trackerUpdateTag;
    public byte[] light;
    public static ModelProperty<CasingType> CASING_PROPERTY = new ModelProperty();

    public BeltTileEntity(TileEntityType<? extends BeltTileEntity> type) {
        super(type);
        this.casing = CasingType.NONE;
        this.color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.field_145850_b, this.field_174879_c);
        }
        if (!AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        if (this.light == null && this.field_145850_b.field_72995_K) {
            this.initializeLight();
            LightUpdater.getInstance().startListening(this.getBeltVolume(), (LightUpdateListener)this);
        }
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.func_195044_w().func_177229_b(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    @Override
    public AxisAlignedBB makeRenderBoundingBox() {
        if (!this.isController()) {
            return super.makeRenderBoundingBox();
        }
        return super.makeRenderBoundingBox().func_186662_g((double)(this.beltLength + 1));
    }

    protected void initializeItemHandler() {
        if (this.field_145850_b.field_72995_K || this.itemHandler.isPresent()) {
            return;
        }
        if (!this.field_145850_b.func_195588_v(this.controller)) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltTileEntity)te).getInventory();
        if (inventory == null) {
            return;
        }
        ItemHandlerBeltSegment handler = new ItemHandlerBeltSegment(inventory, this.index);
        this.itemHandler = LazyOptional.of(() -> handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (side == Direction.UP || BeltBlock.canAccessFromSide(side, this.func_195044_w()))) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandler.invalidate();
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.controller));
        }
        compound.func_74757_a("IsController", this.isController());
        compound.func_74768_a("Length", this.beltLength);
        compound.func_74768_a("Index", this.index);
        NBTHelper.writeEnum(compound, "Casing", this.casing);
        if (this.color.isPresent()) {
            NBTHelper.writeEnum(compound, "Dye", (Enum)this.color.get());
        }
        if (this.isController()) {
            compound.func_218657_a("Inventory", (INBT)this.getInventory().write());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        if (compound.func_74767_n("IsController")) {
            this.controller = this.field_174879_c;
        }
        Optional<Object> optional = this.color = compound.func_74764_b("Dye") ? Optional.of(NBTHelper.readEnum(compound, "Dye", DyeColor.class)) : Optional.empty();
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Controller"));
            }
            this.trackerUpdateTag = compound;
            this.beltLength = compound.func_74762_e("Length");
            this.index = compound.func_74762_e("Index");
        }
        if (this.isController()) {
            this.getInventory().read(compound.func_74775_l("Inventory"));
        }
        CasingType casingBefore = this.casing;
        this.casing = NBTHelper.readEnum(compound, "Casing", CasingType.class);
        if (!clientPacket) {
            return;
        }
        if (casingBefore == this.casing) {
            return;
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.func_145830_o()) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 16);
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new CompoundNBT();
    }

    public void applyColor(DyeColor colorIn) {
        if (colorIn == null ? !this.color.isPresent() : this.color.isPresent() && this.color.get() == colorIn) {
            return;
        }
        for (BlockPos blockPos : BeltBlock.getBeltChain(this.field_145850_b, this.getController())) {
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, blockPos);
            if (belt == null) continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.func_70296_d();
            belt.sendData();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FastRenderDispatcher.enqueueUpdate(belt));
        }
    }

    public BeltTileEntity getControllerTE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.field_145850_b.func_195588_v(this.controller)) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)te;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.field_174879_c : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.field_174879_c.func_177958_n() == this.controller.func_177958_n() && this.field_174879_c.func_177956_o() == this.controller.func_177956_o() && this.field_174879_c.func_177952_p() == this.controller.func_177952_p();
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().func_176743_c().func_179524_a();
        if (this.getBeltFacing().func_176740_k() == Direction.Axis.X) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!AllBlocks.BELT.has(this.func_195044_w())) {
            return false;
        }
        return this.func_195044_w().func_177229_b(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        Direction direction = this.getBeltFacing();
        if (this.func_195044_w().func_177229_b(BeltBlock.SLOPE) == BeltSlope.VERTICAL) {
            return false;
        }
        BeltPart part = (BeltPart)((Object)this.func_195044_w().func_177229_b(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.func_176743_c().func_179524_a() == 1) ^ direction.func_176740_k() == Direction.Axis.X;
        return part == BeltPart.START ^ movingPositively;
    }

    public Vector3i getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public Vector3i getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected Vector3i getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return BlockPos.field_177992_a;
        }
        BlockState blockState = this.func_195044_w();
        Direction beltFacing = (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        BeltSlope slope = (BeltSlope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
        BeltPart part = (BeltPart)((Object)blockState.func_177229_b(BeltBlock.PART));
        Direction.Axis axis = beltFacing.func_176740_k();
        Direction movementFacing = Direction.func_181076_a((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        boolean bl = notHorizontal = blockState.func_177229_b(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.func_176734_d();
        }
        Vector3i movement = movementFacing.func_176730_m();
        boolean slopeBeforeHalf = part == BeltPart.END == (beltFacing.func_176743_c() == Direction.AxisDirection.POSITIVE);
        boolean bl2 = onSlope = notHorizontal && (part == BeltPart.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new Vector3i(movement.func_177958_n(), movingUp ? 1 : -1, movement.func_177952_p());
    }

    public Direction getMovementFacing() {
        Direction.Axis axis = this.getBeltFacing().func_176740_k();
        return Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)(this.getBeltMovementSpeed() < 0.0f ^ axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    protected Direction getBeltFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltTileEntity controllerTE = this.getControllerTE();
            if (controllerTE != null) {
                return controllerTE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        BeltTileEntity controller = this.getControllerTE();
        if (controller == null) {
            return;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private Vector3d getWorldPositionOf(TransportedItemStack transported) {
        BeltTileEntity controllerTE = this.getControllerTE();
        if (controllerTE == null) {
            return Vector3d.field_186680_a;
        }
        return BeltHelper.getVectorForOffset(controllerTE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        if (this.casing == type) {
            return;
        }
        if (this.casing != CasingType.NONE) {
            this.field_145850_b.func_217379_c(2001, this.field_174879_c, Block.func_196246_j((BlockState)(this.casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.getDefaultState() : AllBlocks.BRASS_CASING.getDefaultState())));
        }
        this.casing = type;
        boolean shouldBlockHaveCasing = type != CasingType.NONE;
        BlockState blockState = this.func_195044_w();
        if ((Boolean)blockState.func_177229_b((Property)BeltBlock.CASING) != shouldBlockHaveCasing) {
            KineticTileEntity.switchToBlockState(this.field_145850_b, this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)));
        }
        this.func_70296_d();
        this.sendData();
    }

    private boolean canInsertFrom(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        BlockState state = this.func_195044_w();
        if (state.func_235901_b_(BeltBlock.SLOPE) && (state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.VERTICAL)) {
            return false;
        }
        return this.getMovementFacing() != side.func_176734_d();
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        BrassTunnelTileEntity tunnelTE;
        BeltTileEntity nextBeltController = this.getControllerTE();
        ItemStack inserted = transportedStack.stack;
        ItemStack empty = ItemStack.field_190927_a;
        if (nextBeltController == null) {
            return inserted;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return inserted;
        }
        TileEntity teAbove = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (teAbove instanceof BrassTunnelTileEntity && (tunnelTE = (BrassTunnelTileEntity)teAbove).hasDistributionBehaviour()) {
            if (!tunnelTE.getStackToDistribute().func_190926_b()) {
                return inserted;
            }
            if (!tunnelTE.testFlapFilter(side.func_176734_d(), inserted)) {
                return inserted;
            }
            if (!simulate) {
                BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.func_176734_d(), true);
                tunnelTE.setStackToDistribute(inserted);
            }
            return empty;
        }
        if (this.getSpeed() == 0.0f) {
            return inserted;
        }
        if (this.getMovementFacing() == side.func_176734_d()) {
            return inserted;
        }
        if (!nextInventory.canInsertAtFromSide(this.index, side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        Direction movementFacing = this.getMovementFacing();
        if (!side.func_176740_k().func_200128_b()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.func_176743_c().func_179524_a() * 0.35f;
                if (side.func_176740_k() == Direction.Axis.X) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index : (float)(this.index + 1);
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.func_176734_d(), true);
        nextInventory.addItem(transportedStack);
        nextBeltController.func_70296_d();
        nextBeltController.sendData();
        return empty;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CASING_PROPERTY, (Object)this.casing).build();
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.func_235901_b_(BeltBlock.SLOPE) && (state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.func_177229_b(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof BeltTileEntity && !connectedViaAxes) {
            return this.getController().equals((Object)((BeltTileEntity)target).getController()) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderAsTE() {
        if (this.field_145850_b == null) {
            return this.isController();
        }
        BlockState state = this.func_195044_w();
        return state != null && state.func_235901_b_(BeltBlock.PART) && state.func_177229_b(BeltBlock.PART) == BeltPart.START;
    }

    @Override
    public boolean onLightUpdate(IBlockDisplayReader world, LightType type, GridAlignedBB changed) {
        if (this.field_145846_f) {
            return true;
        }
        GridAlignedBB beltVolume = this.getBeltVolume();
        if (beltVolume.intersects(changed)) {
            if (type == LightType.BLOCK) {
                this.updateBlockLight();
            }
            if (type == LightType.SKY) {
                this.updateSkyLight();
            }
        }
        return false;
    }

    private GridAlignedBB getBeltVolume() {
        BlockPos endPos = BeltHelper.getPositionForOffset(this, this.beltLength - 1);
        GridAlignedBB bb = GridAlignedBB.from(this.field_174879_c, endPos);
        bb.fixMinMax();
        return bb;
    }

    private void initializeLight() {
        if (this.beltLength > 0) {
            this.light = new byte[this.beltLength * 2];
            Vector3i vec = this.getBeltFacing().func_176730_m();
            BeltSlope slope = (BeltSlope)((Object)this.func_195044_w().func_177229_b(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            BlockPos.Mutable pos = new BlockPos.Mutable(this.controller.func_177958_n(), this.controller.func_177956_o(), this.controller.func_177952_p());
            for (int i = 0; i < this.beltLength * 2; i += 2) {
                this.light[i] = (byte)this.field_145850_b.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
                this.light[i + 1] = (byte)this.field_145850_b.func_226658_a_(LightType.SKY, (BlockPos)pos);
                pos.func_196234_d(vec.func_177958_n(), verticality, vec.func_177952_p());
            }
        }
    }

    private void updateBlockLight() {
        Vector3i vec = this.getBeltFacing().func_176730_m();
        BeltSlope slope = (BeltSlope)((Object)this.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        BlockPos.Mutable pos = new BlockPos.Mutable(this.controller.func_177958_n(), this.controller.func_177956_o(), this.controller.func_177952_p());
        for (int i = 0; i < this.beltLength * 2; i += 2) {
            this.light[i] = (byte)this.field_145850_b.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            pos.func_196234_d(vec.func_177958_n(), verticality, vec.func_177952_p());
        }
    }

    private void updateSkyLight() {
        Vector3i vec = this.getBeltFacing().func_176730_m();
        BeltSlope slope = (BeltSlope)((Object)this.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        BlockPos.Mutable pos = new BlockPos.Mutable(this.controller.func_177958_n(), this.controller.func_177956_o(), this.controller.func_177952_p());
        for (int i = 1; i < this.beltLength * 2; i += 2) {
            this.light[i] = (byte)this.field_145850_b.func_226658_a_(LightType.SKY, (BlockPos)pos);
            pos.func_196234_d(vec.func_177958_n(), verticality, vec.func_177952_p());
        }
    }

    public static enum CasingType {
        NONE,
        ANDESITE,
        BRASS;

    }
}

