/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.content.contraptions.relays.advanced.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.OnIsPoweredResult;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Vector;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class Instruction {
    SequencerInstructions instruction;
    InstructionSpeedModifiers speedModifier;
    int value;

    public Instruction(SequencerInstructions instruction) {
        this(instruction, 1);
    }

    public Instruction(SequencerInstructions instruction, int value) {
        this.instruction = instruction;
        this.speedModifier = InstructionSpeedModifiers.FORWARD;
        this.value = value;
    }

    int getDuration(float initialProgress, float speed) {
        int offset = speed > 0.0f && this.speedModifier.value < 0 ? 1 : 2;
        speed *= (float)this.speedModifier.value;
        speed = Math.abs(speed);
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        double metersPerTick = speed / 512.0f;
        switch (this.instruction) {
            case TURN_ANGLE: {
                return (int)((double)((1.0f - initialProgress) * (float)this.value) / degreesPerTick + 1.0);
            }
            case TURN_DISTANCE: {
                return (int)((double)((1.0f - initialProgress) * (float)this.value) / metersPerTick + (double)offset);
            }
            case DELAY: {
                return (int)((1.0f - initialProgress) * (float)this.value + 1.0f);
            }
            case AWAIT: {
                return -1;
            }
        }
        return 0;
    }

    int getSpeedModifier() {
        switch (this.instruction) {
            case TURN_ANGLE: 
            case TURN_DISTANCE: {
                return this.speedModifier.value;
            }
        }
        return 0;
    }

    OnIsPoweredResult onRedstonePulse() {
        return this.instruction == SequencerInstructions.AWAIT ? OnIsPoweredResult.CONTINUE : OnIsPoweredResult.NOTHING;
    }

    public static ListNBT serializeAll(Vector<Instruction> instructions) {
        ListNBT list = new ListNBT();
        instructions.forEach(i -> list.add((Object)i.serialize()));
        return list;
    }

    public static Vector<Instruction> deserializeAll(ListNBT list) {
        if (list.isEmpty()) {
            return Instruction.createDefault();
        }
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        list.forEach(inbt -> instructions.add(Instruction.deserialize((CompoundNBT)inbt)));
        return instructions;
    }

    public static Vector<Instruction> createDefault() {
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        instructions.add(new Instruction(SequencerInstructions.TURN_ANGLE, 90));
        instructions.add(new Instruction(SequencerInstructions.END));
        return instructions;
    }

    CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        NBTHelper.writeEnum(tag, "Type", this.instruction);
        NBTHelper.writeEnum(tag, "Modifier", this.speedModifier);
        tag.func_74768_a("Value", this.value);
        return tag;
    }

    static Instruction deserialize(CompoundNBT tag) {
        Instruction instruction = new Instruction(NBTHelper.readEnum(tag, "Type", SequencerInstructions.class));
        instruction.speedModifier = NBTHelper.readEnum(tag, "Modifier", InstructionSpeedModifiers.class);
        instruction.value = tag.func_74762_e("Value");
        return instruction;
    }
}

