/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class FluidValveInstance
extends ShaftInstance
implements IDynamicInstance {
    protected ModelData pointer;
    protected final double xRot;
    protected final double yRot;
    protected final int pointerRotationOffset;

    public FluidValveInstance(InstancedTileRenderer<?> dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        Direction facing = (Direction)this.blockState.func_177229_b((Property)FluidValveBlock.FACING);
        this.yRot = AngleHelper.horizontalAngle(facing);
        this.xRot = facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0);
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(this.blockState);
        Direction.Axis shaftAxis = KineticTileEntityRenderer.getRotationAxisOf(tile);
        boolean twist = pipeAxis.func_176722_c() && shaftAxis == Direction.Axis.Z || pipeAxis.func_200128_b();
        this.pointerRotationOffset = twist ? 90 : 0;
        this.pointer = this.renderer.getTransformMaterial().getModel(AllBlockPartials.FLUID_VALVE_POINTER, this.blockState).createInstance();
        this.transformPointer((FluidValveTileEntity)tile);
    }

    @Override
    public void beginFrame() {
        FluidValveTileEntity valve = (FluidValveTileEntity)this.tile;
        if (valve.pointer.settled()) {
            return;
        }
        this.transformPointer(valve);
    }

    private void transformPointer(FluidValveTileEntity valve) {
        float pointerRotation = MathHelper.func_219799_g((float)valve.pointer.getValue(AnimationTickHolder.getPartialTicks()), (float)0.0f, (float)-90.0f);
        MatrixStack ms = new MatrixStack();
        MatrixStacker.of(ms).translate((Vector3i)this.getInstancePosition()).centre().rotateY(this.yRot).rotateX(this.xRot).rotateY((float)this.pointerRotationOffset + pointerRotation).unCentre();
        this.pointer.setTransform(ms);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.pointer);
    }

    @Override
    public void remove() {
        super.remove();
        this.pointer.delete();
    }
}

