/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllSoundEvents {
    public static Map<ResourceLocation, SoundEntry> entries = Maps.newHashMap();
    public static final SoundEntry SCHEMATICANNON_LAUNCH_BLOCK = AllSoundEvents.create("schematicannon_launch_block").subtitle("Schematicannon fires").playExisting(SoundEvents.field_187539_bB, 0.1f, 1.1f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SCHEMATICANNON_FINISH = AllSoundEvents.create("schematicannon_finish").subtitle("Schematicannon dings").playExisting(SoundEvents.field_193807_ew, 1.0f, 0.7f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SLIME_ADDED = AllSoundEvents.create("slime_added").subtitle("Slime squishes").playExisting(SoundEvents.field_187884_fr).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION = AllSoundEvents.create("mechanical_press_activation").subtitle("Mechanical Press clangs").playExisting(SoundEvents.field_187689_f, 0.125f, 1.0f).playExisting(SoundEvents.field_187635_cQ, 0.5f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION_ON_BELT = AllSoundEvents.create("mechanical_press_activation_belt").subtitle("Mechanical Press bonks").playExisting(SoundEvents.field_187550_ag, 0.75f, 1.0f).playExisting(SoundEvents.field_187635_cQ, 0.15f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry BLOCKZAPPER_PLACE = AllSoundEvents.create("blockzapper_place").subtitle("Blockzapper zaps").playExisting(SoundEvents.field_187676_dE).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry BLOCKZAPPER_CONFIRM = AllSoundEvents.create("blockzapper_confirm").subtitle("Affirmative ding").playExisting(SoundEvents.field_193807_ew, 0.5f, 0.8f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry BLOCKZAPPER_DENY = AllSoundEvents.create("blockzapper_deny").subtitle("Declining boop").playExisting(SoundEvents.field_187679_dF, 1.0f, 0.5f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry BLAZE_MUNCH = AllSoundEvents.create("blaze_munch").subtitle("Blaze Burner munches").playExisting(SoundEvents.field_187537_bA, 0.5f, 1.0f).category(SoundCategory.BLOCKS).build();

    public static SoundEntryBuilder create(String id) {
        return new SoundEntryBuilder(id);
    }

    public static void register(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEntry entry : entries.values()) {
            entry.register((IForgeRegistry<SoundEvent>)registry);
        }
    }

    public static JsonElement provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : entries.values()) {
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    static class CustomSoundEntry
    extends SoundEntry {
        protected SoundEvent event;

        public CustomSoundEntry(String id, String subtitle, SoundCategory category) {
            super(id, subtitle, category);
        }

        @Override
        public void register(IForgeRegistry<SoundEvent> registry) {
            ResourceLocation location = this.getLocation();
            SoundEvent sound = (SoundEvent)new SoundEvent(location).setRegistryName(location);
            registry.register((IForgeRegistryEntry)sound);
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            list.add(this.getLocation().toString());
            entry.add("sounds", (JsonElement)list);
            entry.addProperty("subtitle", this.getSubtitleKey());
            json.add(this.id, (JsonElement)entry);
        }

        @Override
        void play(World world, PlayerEntity entity, double x, double y, double z, float volume, float pitch) {
            world.func_184148_a(entity, x, y, z, this.event, this.category, volume, pitch);
        }
    }

    static class WrappedSoundEntry
    extends SoundEntry {
        private List<Pair<SoundEvent, Couple<Float>>> wrappedEvents;
        private List<Pair<SoundEvent, Couple<Float>>> compiledEvents;

        public WrappedSoundEntry(String id, String subtitle, List<Pair<SoundEvent, Couple<Float>>> wrappedEvents, SoundCategory category) {
            super(id, subtitle, category);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = Lists.newArrayList();
        }

        @Override
        public void register(IForgeRegistry<SoundEvent> registry) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ResourceLocation location = Create.asResource(this.getIdOf(i));
                SoundEvent sound = (SoundEvent)new SoundEvent(location).setRegistryName(location);
                registry.register((IForgeRegistryEntry)sound);
                this.compiledEvents.add(Pair.of(sound, this.wrappedEvents.get(i).getSecond()));
            }
        }

        protected String getIdOf(int i) {
            return i == 0 ? this.id : this.id + "_compounded_" + i;
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                Pair<SoundEvent, Couple<Float>> pair = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", pair.getFirst().func_187503_a().toString());
                s.addProperty("type", "event");
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i), (JsonElement)entry);
            }
        }

        @Override
        void play(World world, PlayerEntity entity, double x, double y, double z, float volume, float pitch) {
            for (Pair<SoundEvent, Couple<Float>> pair : this.compiledEvents) {
                Couple<Float> volPitch = pair.getSecond();
                world.func_184148_a(entity, x, y, z, pair.getFirst(), this.category, ((Float)volPitch.getFirst()).floatValue() * volume, ((Float)volPitch.getSecond()).floatValue() * pitch);
            }
        }
    }

    public static abstract class SoundEntry {
        protected String id;
        protected String subtitle;
        protected SoundCategory category;

        public SoundEntry(String id, String subtitle, SoundCategory category) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
        }

        public abstract void register(IForgeRegistry<SoundEvent> var1);

        public abstract void write(JsonObject var1);

        public String getSubtitleKey() {
            return "create.subtitle." + this.id;
        }

        public String getId() {
            return this.id;
        }

        public ResourceLocation getLocation() {
            return Create.asResource(this.id);
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(World world, BlockPos pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(World world, BlockPos pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(World world, PlayerEntity entity, BlockPos pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.func_174814_R()) {
                this.play(entity.field_70170_p, null, entity.func_233580_cy_(), volume, pitch);
            }
        }

        public void play(World world, PlayerEntity entity, BlockPos pos, float volume, float pitch) {
            this.play(world, entity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), volume, pitch);
        }

        abstract void play(World var1, PlayerEntity var2, double var3, double var5, double var7, float var9, float var10);
    }

    static class SoundEntryBuilder {
        protected String id;
        protected String subtitle = "unregistered";
        protected SoundCategory category = SoundCategory.BLOCKS;
        List<Pair<SoundEvent, Couple<Float>>> wrappedEvents = Lists.newArrayList();

        public SoundEntryBuilder(String id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder category(SoundCategory category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            this.wrappedEvents.add(Pair.of(event, Couple.create(Float.valueOf(volume), Float.valueOf(pitch))));
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.subtitle, this.category) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category);
            entries.put(entry.getLocation(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements IDataProvider {
        private DataGenerator generator;

        public SoundEntryProvider(DataGenerator generator) {
            this.generator = generator;
        }

        public void func_200398_a(DirectoryCache cache) throws IOException {
            this.generate(this.generator.func_200391_b(), cache);
        }

        public String func_200397_b() {
            return "Create's Custom Sounds";
        }

        public void generate(Path path, DirectoryCache cache) {
            Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            path = path.resolve("assets/create");
            try {
                JsonObject json = new JsonObject();
                entries.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

