/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.util.chess.BitBoardUtility;
import flash.minechess.util.chess.Board;
import flash.minechess.util.chess.BoardRepresentation;
import flash.minechess.util.chess.Move;
import flash.minechess.util.chess.Piece;
import flash.minechess.util.chess.PieceList;
import flash.minechess.util.chess.PrecomputedMoveData;
import java.util.ArrayList;
import java.util.List;

public class MoveGenerator {
    public PromotionMode promotionsToGenerate = PromotionMode.All;
    List<Move> moves;
    boolean isWhiteToMove;
    int friendlyColour;
    int opponentColour;
    int friendlyKingSquare;
    int friendlyColourIndex;
    int opponentColourIndex;
    boolean inCheck;
    boolean inDoubleCheck;
    boolean pinsExistInPosition;
    long checkRayBitmask;
    long pinRayBitmask;
    long opponentKnightAttacks;
    long opponentAttackMapNoPawns;
    public long opponentAttackMap;
    public long opponentPawnAttackMap;
    long opponentSlidingAttackMap;
    boolean genQuiets;
    Board board;

    public List<Move> generateMoves(Board board) {
        return this.generateMoves(board, true);
    }

    public List<Move> generateMoves(Board board, boolean includeQuietMoves) {
        this.board = board;
        this.genQuiets = includeQuietMoves;
        this.init();
        this.calculateAttackData();
        this.generateKingMoves();
        if (this.inDoubleCheck) {
            return this.moves;
        }
        this.generateSlidingMoves();
        this.generateKnightMoves();
        this.generatePawnMoves();
        return this.moves;
    }

    public boolean inCheck() {
        return this.inCheck;
    }

    void init() {
        this.moves = new ArrayList<Move>(64);
        this.inCheck = false;
        this.inDoubleCheck = false;
        this.pinsExistInPosition = false;
        this.checkRayBitmask = 0L;
        this.pinRayBitmask = 0L;
        this.isWhiteToMove = this.board.colourToMove == 8;
        this.friendlyColour = this.board.colourToMove;
        this.opponentColour = this.board.opponentColour;
        this.friendlyKingSquare = this.board.kingSquare[this.board.colourToMoveIndex];
        this.friendlyColourIndex = this.board.whiteToMove ? 0 : 1;
        this.opponentColourIndex = 1 - this.friendlyColourIndex;
    }

    void generateKingMoves() {
        for (int i = 0; i < PrecomputedMoveData.kingMoves[this.friendlyKingSquare].length; ++i) {
            int castleQueensideSquare;
            boolean isCapture;
            byte targetSquare = PrecomputedMoveData.kingMoves[this.friendlyKingSquare][i];
            int pieceOnTargetSquare = this.board.square[targetSquare];
            if (Piece.isColour(pieceOnTargetSquare, this.friendlyColour) || !(isCapture = Piece.isColour(pieceOnTargetSquare, this.opponentColour)) && (!this.genQuiets || this.squareIsInCheckRay(targetSquare)) || this.squareIsAttacked(targetSquare)) continue;
            this.moves.add(new Move(this.friendlyKingSquare, targetSquare));
            if (this.inCheck || isCapture) continue;
            if ((targetSquare == 2 || targetSquare == 58) && this.hasKingsideCastleRight()) {
                int castleKingsideSquare = targetSquare - 1;
                if (this.board.square[castleKingsideSquare] != 0 || this.squareIsAttacked(castleKingsideSquare)) continue;
                this.moves.add(new Move(this.friendlyKingSquare, castleKingsideSquare, 2));
                continue;
            }
            if (targetSquare != 4 && targetSquare != 60 || !this.hasQueensideCastleRight() || this.board.square[castleQueensideSquare = targetSquare + 1] != 0 || this.board.square[castleQueensideSquare + 1] != 0 || this.squareIsAttacked(castleQueensideSquare)) continue;
            this.moves.add(new Move(this.friendlyKingSquare, castleQueensideSquare, 2));
        }
    }

    void generateSlidingMoves() {
        PieceList rooks = this.board.rooks[this.friendlyColourIndex];
        for (int i = 0; i < rooks.getCount(); ++i) {
            this.generateSlidingPieceMoves(rooks.getOccupiedSquare(i), 0, 4);
        }
        PieceList bishops = this.board.bishops[this.friendlyColourIndex];
        for (int i = 0; i < bishops.getCount(); ++i) {
            this.generateSlidingPieceMoves(bishops.getOccupiedSquare(i), 4, 8);
        }
        PieceList queens = this.board.queens[this.friendlyColourIndex];
        for (int i = 0; i < queens.getCount(); ++i) {
            this.generateSlidingPieceMoves(queens.getOccupiedSquare(i), 0, 8);
        }
    }

    void generateSlidingPieceMoves(int startSquare, int startDirIndex, int endDirIndex) {
        boolean isPinned = this.isPinned(startSquare);
        if (this.inCheck && isPinned) {
            return;
        }
        block0: for (int directionIndex = startDirIndex; directionIndex < endDirIndex; ++directionIndex) {
            int targetSquare;
            int targetSquarePiece;
            int currentDirOffset = PrecomputedMoveData.directionOffsets[directionIndex];
            if (isPinned && !this.isMovingAlongRay(currentDirOffset, this.friendlyKingSquare, startSquare)) continue;
            for (int n = 0; n < PrecomputedMoveData.numSquaresToEdge[startSquare][directionIndex] && !Piece.isColour(targetSquarePiece = this.board.square[targetSquare = startSquare + currentDirOffset * (n + 1)], this.friendlyColour); ++n) {
                boolean isCapture = targetSquarePiece != 0;
                boolean movePreventsCheck = this.squareIsInCheckRay(targetSquare);
                if ((movePreventsCheck || !this.inCheck) && (this.genQuiets || isCapture)) {
                    this.moves.add(new Move(startSquare, targetSquare));
                }
                if (isCapture || movePreventsCheck) continue block0;
            }
        }
    }

    void generateKnightMoves() {
        PieceList myKnights = this.board.knights[this.friendlyColourIndex];
        for (int i = 0; i < myKnights.getCount(); ++i) {
            int startSquare = myKnights.getOccupiedSquare(i);
            if (this.isPinned(startSquare)) continue;
            for (int knightMoveIndex = 0; knightMoveIndex < PrecomputedMoveData.knightMoves[startSquare].length; ++knightMoveIndex) {
                byte targetSquare = PrecomputedMoveData.knightMoves[startSquare][knightMoveIndex];
                int targetSquarePiece = this.board.square[targetSquare];
                boolean isCapture = Piece.isColour(targetSquarePiece, this.opponentColour);
                if (!this.genQuiets && !isCapture || Piece.isColour(targetSquarePiece, this.friendlyColour) || this.inCheck && !this.squareIsInCheckRay(targetSquare)) continue;
                this.moves.add(new Move(startSquare, targetSquare));
            }
        }
    }

    void generatePawnMoves() {
        PieceList myPawns = this.board.pawns[this.friendlyColourIndex];
        int pawnOffset = this.friendlyColour == 8 ? 8 : -8;
        int startRank = this.board.whiteToMove ? 1 : 6;
        int finalRankBeforePromotion = this.board.whiteToMove ? 6 : 1;
        int enPassantFile = ((int)(this.board.currentGameState >> 4) & 0xF) - 1;
        int enPassantSquare = -1;
        if (enPassantFile != -1) {
            enPassantSquare = 8 * (this.board.whiteToMove ? 5 : 2) + enPassantFile;
        }
        for (int i = 0; i < myPawns.getCount(); ++i) {
            int squareOneForward;
            boolean oneStepFromPromotion;
            int startSquare = myPawns.getOccupiedSquare(i);
            int rank = BoardRepresentation.rankIndex(startSquare);
            boolean bl = oneStepFromPromotion = rank == finalRankBeforePromotion;
            if (this.genQuiets && this.board.square[squareOneForward = startSquare + pawnOffset] == 0 && (!this.isPinned(startSquare) || this.isMovingAlongRay(pawnOffset, startSquare, this.friendlyKingSquare))) {
                int squareTwoForward;
                if (!this.inCheck || this.squareIsInCheckRay(squareOneForward)) {
                    if (oneStepFromPromotion) {
                        this.makePromotionMoves(startSquare, squareOneForward);
                    } else {
                        this.moves.add(new Move(startSquare, squareOneForward));
                    }
                }
                if (rank == startRank && this.board.square[squareTwoForward = squareOneForward + pawnOffset] == 0 && (!this.inCheck || this.squareIsInCheckRay(squareTwoForward))) {
                    this.moves.add(new Move(startSquare, squareTwoForward, 7));
                }
            }
            for (int j = 0; j < 2; ++j) {
                int epCapturedPawnSquare;
                if (PrecomputedMoveData.numSquaresToEdge[startSquare][PrecomputedMoveData.pawnAttackDirections[this.friendlyColourIndex][j]] <= 0) continue;
                int pawnCaptureDir = PrecomputedMoveData.directionOffsets[PrecomputedMoveData.pawnAttackDirections[this.friendlyColourIndex][j]];
                int targetSquare = startSquare + pawnCaptureDir;
                int targetPiece = this.board.square[targetSquare];
                if (this.isPinned(startSquare) && !this.isMovingAlongRay(pawnCaptureDir, this.friendlyKingSquare, startSquare)) continue;
                if (Piece.isColour(targetPiece, this.opponentColour)) {
                    if (this.inCheck && !this.squareIsInCheckRay(targetSquare)) continue;
                    if (oneStepFromPromotion) {
                        this.makePromotionMoves(startSquare, targetSquare);
                    } else {
                        this.moves.add(new Move(startSquare, targetSquare));
                    }
                }
                if (targetSquare != enPassantSquare || this.inCheckAfterEnPassant(startSquare, targetSquare, epCapturedPawnSquare = targetSquare + (this.board.whiteToMove ? -8 : 8))) continue;
                this.moves.add(new Move(startSquare, targetSquare, 1));
            }
        }
    }

    void makePromotionMoves(int fromSquare, int toSquare) {
        this.moves.add(new Move(fromSquare, toSquare, 3));
        if (this.promotionsToGenerate == PromotionMode.All) {
            this.moves.add(new Move(fromSquare, toSquare, 4));
            this.moves.add(new Move(fromSquare, toSquare, 5));
            this.moves.add(new Move(fromSquare, toSquare, 6));
        } else if (this.promotionsToGenerate == PromotionMode.QueenAndKnight) {
            this.moves.add(new Move(fromSquare, toSquare, 4));
        }
    }

    boolean isMovingAlongRay(int rayDir, int startSquare, int targetSquare) {
        int moveDir = PrecomputedMoveData.directionLookup[targetSquare - startSquare + 63];
        return rayDir == moveDir || -rayDir == moveDir;
    }

    boolean isPinned(int square) {
        return this.pinsExistInPosition && (this.pinRayBitmask >> square & 1L) != 0L;
    }

    boolean squareIsInCheckRay(int square) {
        return this.inCheck && (this.checkRayBitmask >> square & 1L) != 0L;
    }

    boolean hasKingsideCastleRight() {
        int mask = this.board.whiteToMove ? 1 : 4;
        return (this.board.currentGameState & (long)mask) != 0L;
    }

    boolean hasQueensideCastleRight() {
        int mask = this.board.whiteToMove ? 2 : 8;
        return (this.board.currentGameState & (long)mask) != 0L;
    }

    void genSlidingAttackMap() {
        this.opponentSlidingAttackMap = 0L;
        PieceList enemyRooks = this.board.rooks[this.opponentColourIndex];
        for (int i = 0; i < enemyRooks.getCount(); ++i) {
            this.updateSlidingAttackPiece(enemyRooks.getOccupiedSquare(i), 0, 4);
        }
        PieceList enemyQueens = this.board.queens[this.opponentColourIndex];
        for (int i = 0; i < enemyQueens.getCount(); ++i) {
            this.updateSlidingAttackPiece(enemyQueens.getOccupiedSquare(i), 0, 8);
        }
        PieceList enemyBishops = this.board.bishops[this.opponentColourIndex];
        for (int i = 0; i < enemyBishops.getCount(); ++i) {
            this.updateSlidingAttackPiece(enemyBishops.getOccupiedSquare(i), 4, 8);
        }
    }

    void updateSlidingAttackPiece(int startSquare, int startDirIndex, int endDirIndex) {
        block0: for (int directionIndex = startDirIndex; directionIndex < endDirIndex; ++directionIndex) {
            int currentDirOffset = PrecomputedMoveData.directionOffsets[directionIndex];
            for (int n = 0; n < PrecomputedMoveData.numSquaresToEdge[startSquare][directionIndex]; ++n) {
                int targetSquare = startSquare + currentDirOffset * (n + 1);
                int targetSquarePiece = this.board.square[targetSquare];
                this.opponentSlidingAttackMap |= 1L << targetSquare;
                if (targetSquare != this.friendlyKingSquare && targetSquarePiece != 0) continue block0;
            }
        }
    }

    void calculateAttackData() {
        this.genSlidingAttackMap();
        int startDirIndex = 0;
        int endDirIndex = 8;
        if (this.board.queens[this.opponentColourIndex].getCount() == 0) {
            startDirIndex = this.board.rooks[this.opponentColourIndex].getCount() > 0 ? 0 : 4;
            endDirIndex = this.board.bishops[this.opponentColourIndex].getCount() > 0 ? 8 : 4;
        }
        for (int dir = startDirIndex; dir < endDirIndex; ++dir) {
            boolean isDiagonal = dir > 3;
            int n = PrecomputedMoveData.numSquaresToEdge[this.friendlyKingSquare][dir];
            int directionOffset = PrecomputedMoveData.directionOffsets[dir];
            boolean isFriendlyPieceAlongRay = false;
            long rayMask = 0L;
            for (int i = 0; i < n; ++i) {
                int squareIndex = this.friendlyKingSquare + directionOffset * (i + 1);
                rayMask |= 1L << squareIndex;
                int piece = this.board.square[squareIndex];
                if (piece == 0) continue;
                if (Piece.isColour(piece, this.friendlyColour)) {
                    if (isFriendlyPieceAlongRay) break;
                    isFriendlyPieceAlongRay = true;
                    continue;
                }
                int pieceType = Piece.pieceType(piece);
                if ((!isDiagonal || !Piece.isBishopOrQueen(pieceType)) && (isDiagonal || !Piece.isRookOrQueen(pieceType))) break;
                if (isFriendlyPieceAlongRay) {
                    this.pinsExistInPosition = true;
                    this.pinRayBitmask |= rayMask;
                    break;
                }
                this.checkRayBitmask |= rayMask;
                this.inDoubleCheck = this.inCheck;
                this.inCheck = true;
                break;
            }
            if (this.inDoubleCheck) break;
        }
        PieceList opponentKnights = this.board.knights[this.opponentColourIndex];
        this.opponentKnightAttacks = 0L;
        boolean isKnightCheck = false;
        for (int knightIndex = 0; knightIndex < opponentKnights.getCount(); ++knightIndex) {
            int startSquare = opponentKnights.getOccupiedSquare(knightIndex);
            this.opponentKnightAttacks |= PrecomputedMoveData.knightAttackBitboards[startSquare];
            if (isKnightCheck || !BitBoardUtility.containsSquare(this.opponentKnightAttacks, this.friendlyKingSquare)) continue;
            isKnightCheck = true;
            this.inDoubleCheck = this.inCheck;
            this.inCheck = true;
            this.checkRayBitmask |= 1L << startSquare;
        }
        PieceList opponentPawns = this.board.pawns[this.opponentColourIndex];
        this.opponentPawnAttackMap = 0L;
        boolean isPawnCheck = false;
        for (int pawnIndex = 0; pawnIndex < opponentPawns.getCount(); ++pawnIndex) {
            int pawnSquare = opponentPawns.getOccupiedSquare(pawnIndex);
            long pawnAttacks = PrecomputedMoveData.pawnAttackBitboards[pawnSquare][this.opponentColourIndex];
            this.opponentPawnAttackMap |= pawnAttacks;
            if (isPawnCheck || !BitBoardUtility.containsSquare(pawnAttacks, this.friendlyKingSquare)) continue;
            isPawnCheck = true;
            this.inDoubleCheck = this.inCheck;
            this.inCheck = true;
            this.checkRayBitmask |= 1L << pawnSquare;
        }
        int enemyKingSquare = this.board.kingSquare[this.opponentColourIndex];
        this.opponentAttackMapNoPawns = this.opponentSlidingAttackMap | this.opponentKnightAttacks | PrecomputedMoveData.kingAttackBitboards[enemyKingSquare];
        this.opponentAttackMap = this.opponentAttackMapNoPawns | this.opponentPawnAttackMap;
    }

    boolean squareIsAttacked(int square) {
        return BitBoardUtility.containsSquare(this.opponentAttackMap, square);
    }

    boolean inCheckAfterEnPassant(int startSquare, int targetSquare, int epCapturedPawnSquare) {
        this.board.square[targetSquare] = this.board.square[startSquare];
        this.board.square[startSquare] = 0;
        this.board.square[epCapturedPawnSquare] = 0;
        boolean inCheckAfterEpCapture = false;
        if (this.squareAttackedAfterEPCapture(epCapturedPawnSquare, startSquare)) {
            inCheckAfterEpCapture = true;
        }
        this.board.square[targetSquare] = 0;
        this.board.square[startSquare] = 2 | this.friendlyColour;
        this.board.square[epCapturedPawnSquare] = 2 | this.opponentColour;
        return inCheckAfterEpCapture;
    }

    boolean squareAttackedAfterEPCapture(int epCaptureSquare, int capturingPawnStartSquare) {
        int i;
        if (BitBoardUtility.containsSquare(this.opponentAttackMapNoPawns, this.friendlyKingSquare)) {
            return true;
        }
        int dirIndex = epCaptureSquare < this.friendlyKingSquare ? 2 : 3;
        for (i = 0; i < PrecomputedMoveData.numSquaresToEdge[this.friendlyKingSquare][dirIndex]; ++i) {
            int squareIndex = this.friendlyKingSquare + PrecomputedMoveData.directionOffsets[dirIndex] * (i + 1);
            int piece = this.board.square[squareIndex];
            if (piece == 0) continue;
            if (Piece.isColour(piece, this.friendlyColour) || !Piece.isRookOrQueen(piece)) break;
            return true;
        }
        for (i = 0; i < 2; ++i) {
            int piece;
            if (PrecomputedMoveData.numSquaresToEdge[this.friendlyKingSquare][PrecomputedMoveData.pawnAttackDirections[this.friendlyColourIndex][i]] <= 0 || (piece = this.board.square[this.friendlyKingSquare + PrecomputedMoveData.directionOffsets[PrecomputedMoveData.pawnAttackDirections[this.friendlyColourIndex][i]]]) != (2 | this.opponentColour)) continue;
            return true;
        }
        return false;
    }

    public static enum PromotionMode {
        All,
        QueenOnly,
        QueenAndKnight;

    }
}

