/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util;

import flash.minechess.init.SoundInit;
import flash.minechess.main.Main;
import flash.minechess.util.chess.Board;
import flash.minechess.util.chess.FenUtility;
import flash.minechess.util.chess.Move;
import flash.minechess.util.chess.MoveGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Match {
    private static FileWriter fw;
    private Result gameResult;
    private Board board = new Board();
    private UUID whitePlayer;
    private UUID blackPlayer;
    private boolean resignWhite;
    private boolean resignBlack;

    public Match(UUID whitePlayer, UUID blackPlayer) {
        this.board.loadStartPosition();
        this.gameResult = Result.Playing;
        this.whitePlayer = whitePlayer;
        this.blackPlayer = blackPlayer;
        this.resignWhite = false;
        this.resignBlack = false;
    }

    public UUID getWhitePlayer() {
        return this.whitePlayer;
    }

    public UUID getBlackPlayer() {
        return this.blackPlayer;
    }

    public Board getBoard() {
        return this.board;
    }

    public void resign(UUID resignedPlayer) {
        this.resignWhite = resignedPlayer.equals(this.whitePlayer);
        this.resignBlack = resignedPlayer.equals(this.blackPlayer);
    }

    public String getFen() {
        return FenUtility.currentFen(this.board);
    }

    public void loadFen(String fen) {
        this.board.loadPosition(fen);
    }

    public void export() {
        try {
            String path = new File(".").getCanonicalPath();
            File directory = new File(path + "/" + "minechess" + "/saved");
            if (!directory.exists()) {
                Main.LOGGER.debug("Created MineChess save directory");
                directory.mkdirs();
            }
            File matchFile = new File(path + "/" + "minechess" + "/saved/" + this.whitePlayer.toString() + "__" + this.blackPlayer.toString());
            fw = new FileWriter(matchFile);
            fw.write(this.getFen());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Main.LOGGER.debug("Couldn't export match FEN: " + e.getMessage());
        }
    }

    public void loadBoard(String fen) {
        this.board.loadPosition(fen);
    }

    public void notifyPlayerToMove() {
        this.gameResult = this.getGameState();
        MoveGenerator moveGenerator = new MoveGenerator();
        List<Move> moves = moveGenerator.generateMoves(this.board);
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        ServerPlayerEntity playerToMove = playerList.func_177451_a(this.board.whiteToMove ? this.blackPlayer : this.whitePlayer);
        ServerPlayerEntity opponent = playerList.func_177451_a(this.board.whiteToMove ? this.whitePlayer : this.blackPlayer);
        if (playerToMove != null) {
            if (this.gameResult == Result.Playing) {
                SoundEvent moveSound = null;
                moveSound = moveGenerator.inCheck() ? (SoundEvent)SoundInit.CHECK.get() : (this.board.lastMadeMoveIsCapture ? (SoundEvent)SoundInit.CAPTURE.get() : (SoundEvent)SoundInit.MOVE.get());
                playerToMove.func_184185_a(moveSound, 1.0f, 1.0f);
            } else {
                playerToMove.func_184185_a((SoundEvent)SoundInit.CHECK.get(), 1.0f, 1.0f);
                if (opponent != null && playerToMove != null) {
                    opponent.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("result." + this.gameResult.name().toLowerCase()), new Object[]{playerToMove.func_195047_I_()}), false);
                    playerToMove.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("result." + this.gameResult.name().toLowerCase()), new Object[]{playerToMove.func_195047_I_()}), false);
                }
            }
        }
    }

    public void notifyResign() {
        this.gameResult = this.getGameState();
        if (this.gameResult == Result.BlackResigned || this.gameResult == Result.WhiteResigned) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            ServerPlayerEntity white = playerList.func_177451_a(this.whitePlayer);
            ServerPlayerEntity black = playerList.func_177451_a(this.blackPlayer);
            ServerPlayerEntity won = this.gameResult == Result.WhiteResigned ? black : white;
            white.func_184185_a((SoundEvent)SoundInit.CHECK.get(), 1.0f, 1.0f);
            if (white != null && won != null) {
                white.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("result." + this.gameResult.name().toLowerCase()), new Object[]{won.func_195047_I_()}), false);
            }
            if (black != null && won != null) {
                black.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("result." + this.gameResult.name().toLowerCase()), new Object[]{won.func_195047_I_()}), false);
            }
        }
    }

    public Result getGameState() {
        MoveGenerator moveGenerator = new MoveGenerator();
        List<Move> moves = moveGenerator.generateMoves(this.board);
        if (moves.size() == 0) {
            if (moveGenerator.inCheck()) {
                return this.board.whiteToMove ? Result.WhiteIsMated : Result.BlackIsMated;
            }
            return Result.Stalemate;
        }
        if (this.board.fiftyMoveCounter >= 100) {
            return Result.FiftyMoveRule;
        }
        if (this.resignWhite) {
            return Result.WhiteResigned;
        }
        if (this.resignBlack) {
            return Result.BlackResigned;
        }
        return Result.Playing;
    }

    public void makeMove(Move move) {
        this.board.makeMove(move);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        return this.whitePlayer.equals(match.whitePlayer) && this.blackPlayer.equals(match.blackPlayer);
    }

    public static enum Result {
        Playing,
        BlackIsMated,
        WhiteIsMated,
        Stalemate,
        FiftyMoveRule,
        WhiteResigned,
        BlackResigned;

    }
}

