/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.proxy;

import flash.minechess.client.gui.screen.BoardScreen;
import flash.minechess.proxy.CommonProxy;
import flash.minechess.util.Match;
import flash.minechess.util.MatchUtil;
import flash.minechess.util.chess.Move;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class ClientProxy
extends CommonProxy {
    Minecraft minecraft = Minecraft.func_71410_x();

    @Override
    public void updateBoard(String fen, Move move) {
        Match match = MatchUtil.findMatch(this.minecraft.field_71439_g.func_110124_au());
        if (match != null) {
            match.getBoard().loadPosition(fen);
            if (this.minecraft.field_71462_r instanceof BoardScreen) {
                BoardScreen boardScreen = (BoardScreen)this.minecraft.field_71462_r;
                boardScreen.onMoveMade(match.getBoard(), move);
            }
            if (match.getGameState() != Match.Result.Playing) {
                MatchUtil.finishMatch(match.getWhitePlayer(), match.getBlackPlayer());
            }
        }
    }

    @Override
    public void startMatch(UUID whitePlayer, UUID blackPlayer) {
        MatchUtil.newMatch(whitePlayer, blackPlayer);
    }

    @Override
    public void syncMatch(UUID whitePlayer, UUID blackPlayer, String fen, int lastStartSquare, int lastTargetSquare) {
        Match match = new Match(whitePlayer, blackPlayer);
        if (!MatchUtil.matchList.contains(match)) {
            match.loadFen(fen);
            if (lastStartSquare >= 0 && lastStartSquare < 64 && lastTargetSquare >= 0 && lastTargetSquare < 64) {
                match.getBoard().lastMadeMove = new Move(lastStartSquare, lastTargetSquare);
            }
            MatchUtil.matchList.add(match);
        }
    }

    @Override
    public void resignMatch(UUID playerToResign) {
        Match match = MatchUtil.findMatch(playerToResign);
        if (match != null) {
            match.resign(playerToResign);
            if (match.getGameState() != Match.Result.Playing) {
                MatchUtil.finishMatch(match.getWhitePlayer(), match.getBlackPlayer());
            }
        }
    }
}

